/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.apiimpl.autocrafting.engine.task;

import com.raoulvdberge.refinedstorage.api.autocrafting.ICraftingPattern;
import com.raoulvdberge.refinedstorage.api.autocrafting.ICraftingPatternContainer;
import com.raoulvdberge.refinedstorage.api.autocrafting.craftingmonitor.ICraftingMonitorElement;
import com.raoulvdberge.refinedstorage.api.autocrafting.engine.CraftingTaskReadException;
import com.raoulvdberge.refinedstorage.api.autocrafting.engine.ICraftingRequestInfo;
import com.raoulvdberge.refinedstorage.api.network.INetwork;
import com.raoulvdberge.refinedstorage.apiimpl.API;
import com.raoulvdberge.refinedstorage.apiimpl.autocrafting.craftingmonitor.CraftingMonitorElementError;
import com.raoulvdberge.refinedstorage.apiimpl.autocrafting.craftingmonitor.CraftingMonitorElementFluidRender;
import com.raoulvdberge.refinedstorage.apiimpl.autocrafting.craftingmonitor.CraftingMonitorElementItemRender;
import com.raoulvdberge.refinedstorage.apiimpl.autocrafting.engine.task.Task;
import com.raoulvdberge.refinedstorage.apiimpl.autocrafting.engine.task.inputs.Input;
import com.raoulvdberge.refinedstorage.apiimpl.autocrafting.engine.task.inputs.Output;
import com.raoulvdberge.refinedstorage.apiimpl.autocrafting.engine.task.inputs.RestockableInput;
import com.raoulvdberge.refinedstorage.util.CraftingEngineUtils;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongArrayList;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import org.apache.commons.lang3.tuple.Pair;

public class ProcessingTask
extends Task {
    public static final String TYPE = "processing";
    private static final String NBT_STATE = "State";
    private static final String NBT_HAS_ITEM_INPUTS = "HasItemInputs";
    private static final String NBT_HAS_FLUID_INPUTS = "HasFluidInputs";
    private ProcessingState state = ProcessingState.READY;
    private int crafterIndex;
    private boolean finished;
    private final boolean hasFluidInputs;
    private final boolean hasItemInputs;
    private final List<Pair<Input, Integer>> generatedPairs = new ObjectArrayList(this.inputs.size());

    public ProcessingTask(@Nonnull ICraftingPattern pattern, ICraftingRequestInfo requestInfo) {
        super(pattern, requestInfo);
        this.hasFluidInputs = this.inputs.stream().anyMatch(Input::isFluid);
        this.hasItemInputs = this.inputs.stream().anyMatch(i -> !i.isFluid());
    }

    public ProcessingTask(@Nonnull INetwork network, @Nonnull NBTTagCompound compound) throws CraftingTaskReadException {
        super(network, compound);
        if (this.amountNeeded < 1L) {
            this.finished = true;
        }
        this.hasItemInputs = compound.func_74767_n(NBT_HAS_ITEM_INPUTS);
        this.hasFluidInputs = compound.func_74767_n(NBT_HAS_FLUID_INPUTS);
        try {
            this.state = ProcessingState.valueOf(compound.func_74779_i(NBT_STATE));
        }
        catch (IllegalArgumentException e) {
            throw new CraftingTaskReadException("Processing task has unknown state");
        }
    }

    @Override
    public int update(@Nonnull INetwork network, @Nonnull ICraftingPatternContainer container, int toCraft) {
        if (this.amountNeeded < 1L) {
            this.finished = true;
            network.getCraftingManager().onTaskChanged();
            return 0;
        }
        if ((long)toCraft > this.amountNeeded) {
            toCraft = (int)this.amountNeeded;
        }
        for (Input input : this.inputs) {
            toCraft = (int)Math.min(input.getMinimumCraftableAmount(), (long)toCraft);
        }
        if (toCraft < 1) {
            return 0;
        }
        if (container.getCrafterMode() == ICraftingPatternContainer.CrafterMode.PULSE_INSERTS_NEXT_SET) {
            toCraft = 1;
        }
        if (container.isLocked()) {
            this.state = ProcessingState.LOCKED;
            network.getCraftingManager().onTaskChanged();
            return 0;
        }
        if (this.hasFluidInputs && container.getConnectedFluidInventory() == null || this.hasItemInputs && container.getConnectedInventory() == null) {
            this.state = ProcessingState.MACHINE_NONE;
            network.getCraftingManager().onTaskChanged();
            return 0;
        }
        List<Pair<Input, Integer>> pairs = this.tryInsertIntoContainer(container, toCraft);
        if (pairs.isEmpty()) {
            this.state = ProcessingState.MACHINE_DOES_NOT_ACCEPT;
            network.getCraftingManager().onTaskChanged();
            return 0;
        }
        toCraft = pairs.stream().mapToInt(p -> (int)Math.floor((double)((Integer)p.getRight()).intValue() / (double)((Input)p.getLeft()).getQuantityPerCraft())).min().orElseThrow(IllegalStateException::new);
        if (toCraft < 1) {
            this.state = ProcessingState.MACHINE_DOES_NOT_ACCEPT;
            network.getCraftingManager().onTaskChanged();
            return 0;
        }
        this.generateAndInsertIntoContainer(container, toCraft);
        container.onUsedForProcessing();
        this.state = ProcessingState.READY;
        if (this.amountNeeded < 1L) {
            this.finished = true;
        }
        network.getCraftingManager().onTaskChanged();
        return toCraft;
    }

    public int supplyOutput(ItemStack stack, int trackedAmount) {
        Output matchingOutput = CraftingEngineUtils.findMatchingItemOutput(this.outputs, stack);
        if (matchingOutput == null) {
            return trackedAmount;
        }
        RestockableInput matchingInput = CraftingEngineUtils.findMatchingRestockableItemInput(this.inputs, stack);
        long inputRemainder = stack.func_190916_E();
        if (matchingInput != null && matchingInput.getAmountMissing() > 0L && matchingOutput.getProcessingAmount() > 0L && matchingOutput.getMissingSets() * (long)matchingInput.getQuantityPerCraft() != matchingInput.getProcessingAmount()) {
            inputRemainder = matchingInput.increaseItemStackAmount(stack, stack.func_190916_E());
        }
        if (matchingOutput.getProcessingAmount() > 0L) {
            int newlyTrackedAmount = 0;
            if (stack.func_190916_E() > trackedAmount) {
                newlyTrackedAmount = this.trackAndUpdate(matchingOutput, stack.func_190916_E() - trackedAmount);
                trackedAmount += newlyTrackedAmount;
            }
            stack.func_190920_e((int)Math.min((long)newlyTrackedAmount, inputRemainder));
            int newStackSize = stack.func_190916_E();
            if (!this.getParents().isEmpty()) {
                Iterator<Task> iterator = this.getParents().iterator();
                while (!stack.func_190926_b() && iterator.hasNext()) {
                    iterator.next().supplyInput(stack);
                }
            }
            stack.func_190920_e((int)(inputRemainder - (long)(newStackSize - stack.func_190916_E())));
        }
        return trackedAmount;
    }

    public int supplyOutput(FluidStack stack, int trackedAmount) {
        Output matchingOutput = CraftingEngineUtils.findMatchingFluidOutput(this.outputs, stack);
        if (matchingOutput == null) {
            return trackedAmount;
        }
        RestockableInput matchingInput = CraftingEngineUtils.findMatchingRestockableFluidInput(this.inputs, stack);
        long inputRemainder = stack.amount;
        if (matchingInput != null && matchingInput.getAmountMissing() > 0L && matchingOutput.getProcessingAmount() > 0L && matchingOutput.getMissingSets() * (long)matchingInput.getQuantityPerCraft() != matchingInput.getProcessingAmount()) {
            inputRemainder = matchingInput.increaseFluidStackAmount(stack.amount);
        }
        if (matchingOutput.getProcessingAmount() > 0L) {
            int newlyTrackedAmount = 0;
            if (stack.amount > trackedAmount) {
                newlyTrackedAmount = this.trackAndUpdate(matchingOutput, stack.amount - trackedAmount);
                trackedAmount += newlyTrackedAmount;
            }
            int newStackSize = stack.amount = (int)Math.min((long)newlyTrackedAmount, inputRemainder);
            if (!this.getParents().isEmpty()) {
                Iterator<Task> iterator = this.getParents().iterator();
                while (stack.amount > 0 && iterator.hasNext()) {
                    iterator.next().supplyInput(stack);
                }
            }
            stack.amount = (int)(inputRemainder - (long)(newStackSize - stack.amount));
        }
        return trackedAmount;
    }

    private int trackAndUpdate(Output output, long trackableAmount) {
        long outputProcessingAmount = output.getProcessingAmount();
        int insertedInputSets = this.inputs.stream().mapToInt(input -> (int)(input.getProcessingAmount() / (long)input.getQuantityPerCraft())).min().orElseThrow(IllegalStateException::new);
        if (insertedInputSets > 0) {
            int remainder = (int)(outputProcessingAmount % (long)output.getQuantityPerCraft());
            trackableAmount = insertedInputSets == 1 ? Math.min(trackableAmount, remainder == 0 ? (long)output.getQuantityPerCraft() : (long)remainder) : Math.min(trackableAmount, (long)(insertedInputSets - 1) * (long)output.getQuantityPerCraft() + (long)(remainder == 0 ? output.getQuantityPerCraft() : remainder));
            if (trackableAmount < 1L) {
                return 0;
            }
        } else {
            return 0;
        }
        long oldCompletedSets = output.getCompletedSets();
        output.setProcessingAmount(output.getProcessingAmount() - trackableAmount);
        if (output.getProcessingAmount() < 1L) {
            output.setCompletedSets((long)Math.ceil((double)output.getAmountNeeded() / (double)output.getQuantityPerCraft()));
        } else {
            output.setCompletedSets((long)Math.floor((double)(output.getAmountNeeded() - output.getProcessingAmount()) / (double)output.getQuantityPerCraft()));
        }
        long smallestCompletedSetCount = this.outputs.stream().mapToLong(Output::getCompletedSets).min().orElseThrow(() -> new IllegalStateException("Outputs list is empty"));
        long newlyCompletedSets = smallestCompletedSetCount - oldCompletedSets;
        if (newlyCompletedSets > 0L) {
            this.amountNeeded -= newlyCompletedSets;
            for (Input input2 : this.inputs) {
                input2.setProcessingAmount(input2.getProcessingAmount() - (long)input2.getQuantityPerCraft() * newlyCompletedSets);
            }
        }
        return (int)(outputProcessingAmount - output.getProcessingAmount());
    }

    private ItemStack insertIntoInventory(@Nullable IItemHandler dest, @Nonnull ItemStack stack) {
        if (dest == null) {
            return stack;
        }
        for (int i = 0; i < dest.getSlots() && !(stack = dest.insertItem(i, stack, false)).func_190926_b(); ++i) {
        }
        return stack;
    }

    private void simulateInsertionIntoInventory(@Nullable IItemHandler dest, @Nonnull List<LongArrayList> counts) {
        if (dest == null) {
            return;
        }
        Int2ObjectOpenHashMap slotToStackMap = new Int2ObjectOpenHashMap();
        for (int i = 0; i < dest.getSlots(); ++i) {
            for (int j = 0; j < counts.size(); ++j) {
                LongArrayList list = counts.get(j);
                Input input = (Input)this.inputs.get(j);
                for (int k = 0; k < list.size(); ++k) {
                    ItemStack destStack;
                    ItemStack stack = input.getItemStacks().get(k);
                    int stackCount = (int)list.getLong(k);
                    if (stackCount < 1) continue;
                    ItemStack mapStack = (ItemStack)slotToStackMap.get(i);
                    ItemStack itemStack = destStack = mapStack != null ? mapStack : dest.getStackInSlot(i);
                    if ((!destStack.func_190926_b() || mapStack != null) && !API.instance().getComparer().isEqualNoQuantity(stack, destStack) || !dest.isItemValid(i, stack)) continue;
                    int prevCount = stack.func_190916_E();
                    stack.func_190920_e(stackCount);
                    int insertedAmount = stackCount - dest.insertItem(i, stack, true).func_190916_E();
                    stack.func_190920_e(prevCount);
                    if (mapStack == null && insertedAmount > 0) {
                        slotToStackMap.put(i, (Object)stack);
                    }
                    list.set(k, (long)Math.max(stackCount - insertedAmount, 0));
                }
            }
        }
    }

    private List<Pair<Input, Integer>> tryInsertIntoContainer(@Nonnull ICraftingPatternContainer container, int toCraft) {
        this.generatedPairs.clear();
        IItemHandler connectedInventory = container.getConnectedInventory();
        IFluidHandler connectedFluidInventory = container.getConnectedFluidInventory();
        ArrayList<LongArrayList> allInputCounts = new ArrayList<LongArrayList>();
        for (Input input : this.inputs) {
            allInputCounts.add(new LongArrayList(input.getCurrentInputCounts().size()));
        }
        block1: for (int j = 0; j < this.inputs.size(); ++j) {
            Input input;
            input = (Input)this.inputs.get(j);
            int amount = toCraft * input.getQuantityPerCraft();
            if (input.isFluid()) {
                int oldAmount = input.getFluidStack().amount;
                FluidStack newStack = input.getFluidStack();
                newStack.amount = amount;
                int insertedAmount = connectedFluidInventory.fill(newStack, false);
                if (insertedAmount < 1) {
                    return Collections.emptyList();
                }
                this.generatedPairs.add((Pair<Input, Integer>)Pair.of((Object)input, (Object)insertedAmount));
                newStack.amount = oldAmount;
                continue;
            }
            long tempAmount = amount;
            LongArrayList inputCounts = input.getCurrentInputCounts();
            for (int i = 0; i < inputCounts.size(); ++i) {
                long currentInputCount = inputCounts.getLong(i);
                if (currentInputCount < 1L) {
                    ((LongArrayList)allInputCounts.get(j)).add(-1L);
                    continue;
                }
                if (tempAmount < 1L) continue block1;
                long newInputCount = currentInputCount - tempAmount;
                if (newInputCount < 0L) {
                    tempAmount = -newInputCount;
                    newInputCount = 0L;
                } else {
                    tempAmount = 0L;
                }
                ((LongArrayList)allInputCounts.get(j)).add(currentInputCount - newInputCount);
            }
        }
        this.simulateInsertionIntoInventory(connectedInventory, allInputCounts);
        for (int i = 0; i < allInputCounts.size(); ++i) {
            LongArrayList list = (LongArrayList)allInputCounts.get(i);
            Input input = (Input)this.inputs.get(i);
            for (int j = 0; j < list.size(); ++j) {
                long c = list.getLong(j);
                if (c == -1L) continue;
                this.generatedPairs.add((Pair<Input, Integer>)Pair.of((Object)input, (Object)(toCraft * input.getQuantityPerCraft() - (int)c)));
                input.getItemStacks().get(j).func_190920_e(1);
            }
        }
        return this.generatedPairs;
    }

    private void generateAndInsertIntoContainer(@Nonnull ICraftingPatternContainer container, int toCraft) {
        IItemHandler connectedInventory = container.getConnectedInventory();
        IFluidHandler connectedFluidInventory = container.getConnectedFluidInventory();
        for (Input input : this.inputs) {
            LongArrayList oldInputCounts = input.getCurrentInputCounts().clone();
            input.decreaseInputAmount((long)toCraft * (long)input.getQuantityPerCraft());
            if (input.isFluid()) {
                FluidStack newStack = input.getFluidStack().copy();
                newStack.amount = input.getQuantityPerCraft() * toCraft;
                int remainder = newStack.amount - connectedFluidInventory.fill(newStack, true);
                input.setProcessingAmount(input.getProcessingAmount() + (long)(newStack.amount - remainder));
                continue;
            }
            for (int i = 0; i < oldInputCounts.size(); ++i) {
                long newInputCount;
                long oldInputCount = oldInputCounts.getLong(i);
                long diff = oldInputCount - (newInputCount = input.getCurrentInputCounts().getLong(i));
                if (diff < 1L) continue;
                ItemStack remainder = this.insertIntoInventory(connectedInventory, ItemHandlerHelper.copyStackWithSize((ItemStack)input.getItemStacks().get(i), (int)((int)diff)));
                input.setProcessingAmount(input.getProcessingAmount() + (diff - (long)remainder.func_190916_E()));
            }
        }
    }

    @Override
    @Nonnull
    public NBTTagCompound writeToNbt(@Nonnull NBTTagCompound compound) {
        super.writeToNbt(compound);
        compound.func_74757_a(NBT_HAS_ITEM_INPUTS, this.hasItemInputs);
        compound.func_74757_a(NBT_HAS_FLUID_INPUTS, this.hasFluidInputs);
        compound.func_74778_a(NBT_STATE, this.state.toString());
        return compound;
    }

    @Override
    @Nonnull
    public String getTaskType() {
        return TYPE;
    }

    @Override
    @Nonnull
    public List<ICraftingMonitorElement> getCraftingMonitorElements() {
        if (this.isFinished()) {
            return Collections.emptyList();
        }
        boolean hasError = this.state != ProcessingState.READY;
        ObjectArrayList elements = new ObjectArrayList(this.inputs.size() + this.outputs.size());
        for (Input input : this.inputs) {
            if (input.isFluid()) {
                CraftingMonitorElementFluidRender fluid = new CraftingMonitorElementFluidRender(input.getFluidStack(), input.getTotalInputAmount(), input.getProcessingAmount(), 0L, input.getToCraftAmount());
                elements.add(hasError ? this.getErrorElement(fluid) : fluid);
                continue;
            }
            CraftingMonitorElementItemRender item = new CraftingMonitorElementItemRender(input.getCompareableItemStack(), input.getTotalInputAmount(), input.getProcessingAmount(), 0L, input.getToCraftAmount());
            elements.add(hasError ? this.getErrorElement(item) : item);
        }
        for (Output output : this.outputs) {
            if (output.isFluid()) {
                elements.add(new CraftingMonitorElementFluidRender(output.getFluidStack(), 0L, 0L, output.getProcessingAmount(), 0L));
                continue;
            }
            elements.add(new CraftingMonitorElementItemRender(output.getCompareableItemStack(), 0L, 0L, output.getProcessingAmount(), 0L));
        }
        return elements;
    }

    @Override
    @Nonnull
    public List<ItemStack> getLooseItemStacks() {
        return Collections.emptyList();
    }

    @Override
    @Nonnull
    public List<FluidStack> getLooseFluidStacks() {
        return Collections.emptyList();
    }

    @Nullable
    private CraftingMonitorElementError getErrorElement(ICraftingMonitorElement base) {
        switch (this.state) {
            case LOCKED: {
                return new CraftingMonitorElementError(base, "gui.refinedstorage:crafting_monitor.crafter_is_locked");
            }
            case MACHINE_NONE: {
                return new CraftingMonitorElementError(base, "gui.refinedstorage:crafting_monitor.machine_none");
            }
            case MACHINE_DOES_NOT_ACCEPT: {
                return new CraftingMonitorElementError(base, "gui.refinedstorage:crafting_monitor.machine_does_not_accept");
            }
        }
        return null;
    }

    @Override
    public boolean isFinished() {
        return this.finished;
    }

    public int getCrafterIndex() {
        return this.crafterIndex;
    }

    public void setCrafterIndex(int crafterIndex) {
        this.crafterIndex = crafterIndex;
    }

    private static enum ProcessingState {
        READY,
        MACHINE_NONE,
        MACHINE_DOES_NOT_ACCEPT,
        LOCKED;

    }
}

